class goWarShell12 extends Projectile;

#exec AUDIO IMPORT FILE="Sounds\ww2.wav" NAME="ww2" GROUP=Redeemer

var float CannonTimer, SmokeRate;
var redeemertrail trail;

function WarnCannons()
{
    local Pawn P;

    for ( P=Level.Pawnlist; P!=None; P=P.NextPawn )
        if ( P.IsA('TeamCannon') && !P.IsInState('TrackWarhead') && P.LineOfSightTo(self) )
        {
            P.target = self;
            P.GotoState('TrackWarhead');
        }
}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, vector momentum, name damageType )
{
    if ( NDamage > 5 )
    {
        PlaySound(Sound'goblast',,6.0);
        spawn(class'goWarExplosion',,,Location);
        HurtRadius(Damage,350.0, MyDamageType, MomentumTransfer, HitLocation );
        RemoteRole = ROLE_SimulatedProxy;                   
        Destroy();
    }
}

auto state Flying
{
    simulated function ZoneChange( Zoneinfo NewZone )
    {
        local waterring w;
        
        if ( NewZone.bWaterZone != Region.Zone.bWaterZone )
        {
            w = Spawn(class'WaterRing',,,,rot(16384,0,0));
            w.DrawScale = 0.2;
            w.RemoteRole = ROLE_None; 
        }   
    }

    function ProcessTouch (Actor Other, Vector HitLocation)
    {
        if ( Other != instigator ) 
            Explode(HitLocation,Normal(HitLocation-Other.Location));
    }

    function Explode(vector HitLocation, vector HitNormal)
    {
        if ( Role < ROLE_Authority )
            return;

        HurtRadius(Damage,300.0, MyDamageType, MomentumTransfer, HitLocation );                 
        spawn(class'TOMShockWave',,,HitLocation+ HitNormal*16);
        RemoteRole = ROLE_SimulatedProxy;                   
        Destroy();
    }

    function BeginState()
    {
        local vector InitialDir;

        initialDir = vector(Rotation);
        if ( Role == ROLE_Authority )   
            Velocity = speed*initialDir;
        Acceleration = initialDir*50;
    }
}

simulated function HitWall (vector HitNormal, actor Wall)
{
    if ( Role == ROLE_Authority )
    {
        if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
            Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');

        MakeNoise(1.0);
    }
    Explode(Location + ExploWallOut * HitNormal, HitNormal);
    if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
       Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
       ExplosionDecal = None;
}

defaultproperties
{
     ExplosionDecal=class'RidiculousDeemer.goNuclearMarkSnoopy'
     DrawScale=1.100000
     speed=800.000000
     Damage=200.000000
     MomentumTransfer=10000
     MyDamageType=RedeemerDeath
     bNetTemporary=False
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'Botpack.stukkam'
     AmbientGlow=78
     bUnlit=True
     SoundRadius=100
     SoundVolume=255
     AmbientSound=Sound'ww2'
     CollisionRadius=15.000000
     CollisionHeight=8.000000
     bProjTarget=True
     bFixedRotationDir=True
     RotationRate=(Pitch=24000,Yaw=0,Roll=-24000),
}